<?php

/**
 * This file is part of the froxlor project.
 * Copyright (c) 2010 the froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     froxlor team <team@froxlor.org>
 * @author     Tim Zielosko <tim.zielosko@syscp.de>
 * @author     Aldo Reset <aldo.reset@placenet.org>
 * @author     Romain MARIADASSOU <roms2000@free.fr>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'admin' => [
		'overview' => 'Sommaire',
		'ressourcedetails' => 'Ressources utilisées',
		'systemdetails' => 'Informations du système',
		'froxlordetails' => 'Informations de froxlor',
		'installedversion' => 'Version installée',
		'latestversion' => 'Dernière version en date',
		'lookfornewversion' => [
			'clickhere' => 'Vérifier par internet',
			'error' => 'Erreur pour vérifier la dernière version',
		],
		'resources' => 'Ressources',
		'customer' => 'Compte',
		'customers' => 'Comptes',
		'customer_add' => 'Ajouter un compte',
		'customer_edit' => 'Modifier un compte',
		'domains' => 'Domaines',
		'domain_add' => 'Ajouter un domaine',
		'domain_edit' => 'Modifier le domaine',
		'subdomainforemail' => 'Sous-domaines comme domaine e-mail',
		'admin' => 'Administrateur',
		'admins' => 'Administrateurs',
		'admin_add' => 'Ajouter un administrateur',
		'admin_edit' => 'Modifier un administrateur',
		'customers_see_all' => 'Peut voir tous les comptes ?',
		'change_serversettings' => 'Peut modifier la configuration du serveur ?',
		'server' => 'Système',
		'serversettings' => 'Paramètres',
		'rebuildconf' => 'Régénérer la configuration',
		'stdsubdomain' => 'Sous-domaine type',
		'stdsubdomain_add' => 'Ajouter un sous-domaine type',
		'phpenabled' => 'PHP activé',
		'deactivated' => 'Désactiver',
		'deactivated_user' => 'Désactiver l\'utilisateur',
		'sendpassword' => 'Envoyer le mot de passe',
		'ownvhostsettings' => 'Configuration spéciale du vHost',
		'configfiles' => [
			'serverconfiguration' => 'Exemple de configuration',
			'overview' => 'Aperçu',
			'wizard' => 'Assistant',
			'distribution' => 'Distribution',
			'service' => 'Service',
			'daemon' => 'Démon',
			'http' => 'Serveur Web (HTTP)',
			'dns' => 'Serveur de Noms (DNS)',
			'mail' => 'Serveur de Mails (IMAP/POP3)',
			'smtp' => 'Serveur de Mails (SMTP)',
			'ftp' => 'Serveur FTP',
			'etc' => 'Autres (Système)',
			'choosedistribution' => '-- Choisissez une distribution --',
			'chooseservice' => '-- Choisissez un service --',
			'choosedaemon' => '-- Choisissez un démon --',
			'statistics' => 'Statistiques',
		],
		'templates' => [
			'templates' => 'Modèles',
			'template_add' => 'Ajouter un modèle',
			'template_edit' => 'Modifier un modèle',
			'action' => 'Action',
			'email' => 'E-mail',
			'subject' => 'Référence',
			'mailbody' => 'Texte de l\'e-mail',
			'createcustomer' => 'E-mail de bienvenue pour les nouveaux clients',
			'pop_success' => 'E-mail de bienvenue pour les nouveaux accès e-mail',
			'template_replace_vars' => 'Les variables qui seront remplacées dans le template :',
			'FIRSTNAME' => 'Sera remplacé par le prénom.',
			'NAME' => 'Sera remplacé par le nom.',
			'USERNAME' => 'Sera remplacé par le login.',
			'PASSWORD' => 'Sera remplacé par le mot de passe du client.',
			'EMAIL' => 'Sera remplacé par l\'accès e-mail.',
			'TRAFFIC' => 'Sera remplacé par le taux de trafic qui a été attribué à l\'utilisateur.',
			'TRAFFICUSED' => 'Sera remplacé par le taux de trafic qui a été consommé par l\'utilisateur.',
			'pop_success_alternative' => 'Message de bienvenue envoyé à l\'adresse e-mail alternative pour les nouveaux comptes e-mails',
			'EMAIL_PASSWORD' => 'Remplacer par le mot de passe du compte POP3 / IMAP.',
		],
		'ipsandports' => [
			'ipsandports' => 'IPs et ports',
			'add' => 'Ajouter une IP / port',
			'edit' => 'Modifier une IP / port',
			'create_listen_statement' => 'Déclaration des ports d\'écoute',
			'create_namevirtualhost_statement' => 'Déclaration des hôtes virtuels "NameVirtualHost"',
			'create_vhostcontainer' => 'Déclaration des conteneurs virtuels "vHost"',
			'create_vhostcontainer_servername_statement' => 'Déclaration des noms d\'hôtes "ServerName" dans les conteneurs virtuels "vHost"',
			'enable_ssl' => 'Est-ce un port SSL ?',
			'ssl_cert_file' => 'Emplacement du certificat SSL',
		],
		'memorylimitdisabled' => 'Désactivé',
		'valuemandatory' => 'Cette valeur est obligatoire',
		'valuemandatorycompany' => 'Vous devez indiquer au moins l\'une des 3 valeurs suivantes : "nom" ou "prénom" ou "entreprise"',
		'serversoftware' => 'Logiciel Serveur',
		'phpversion' => 'Version de PHP',
		'phpmemorylimit' => 'Limite mémoire de PHP',
		'mysqlserverversion' => 'Version du serveur MySQL',
		'mysqlclientversion' => 'Version du client MySQL',
		'webserverinterface' => 'Interface Web',
		'accountsettings' => 'Paramètres du compte',
		'panelsettings' => 'Paramètres du panel',
		'systemsettings' => 'Paramètres du système',
		'webserversettings' => 'Paramètres du serveur Web',
		'mailserversettings' => 'Paramètres du serveur de Mail',
		'nameserversettings' => 'Paramètres du serveur de Noms',
		'updatecounters' => 'Recalculer les ressources utilisées',
		'subcanemaildomain' => [
			'never' => 'Jamais',
			'choosableno' => 'A choisir, par défaut : non',
			'choosableyes' => 'A choisir, par défaut : oui',
			'always' => 'Toujours',
		],
		'webalizersettings' => 'Paramètres pour Webalizer',
		'webalizer' => [
			'normal' => 'Normal',
			'quiet' => 'Silencieux',
			'veryquiet' => 'Aucune sortie',
		],
		'domain_nocustomeraddingavailable' => 'Il n\'est acutellement pas possible d\'ajouter de domaines. Vous devez d\'abord ajouter un client.',
		'loggersettings' => 'Paramètres des logs',
		'logger' => [
			'normal' => 'normal',
			'paranoid' => 'paranoÃ¯aque',
		],
		'emaildomain' => 'Domaine e-mail',
		'email_only' => 'Seulement des e-mails ?',
		'wwwserveralias' => 'Ajouter un "www." à l\'alias du serveur "ServerAlias"',
		'subject' => 'Sujet',
		'recipient' => 'Destinataire',
		'message' => 'Ecrire un message',
		'text' => 'Message',
		'sslsettings' => 'Paramètres SSL',
		'dkimsettings' => 'Paramètres DKIM',
		'caneditphpsettings' => 'Peut changer les paramétres PHP du domaine ?',
		'allips' => 'Toutes les adresses IP',
		'awstatssettings' => 'Paramètres Awstats',
		'domain_dns_settings' => 'Paramètres DNS',
		'activated' => 'Activé',
		'statisticsettings' => 'Paramètres des statistiques',
		'or' => 'ou',
		'sysload' => 'Charge du système',
		'noloadavailable' => 'Non disponible',
		'nouptimeavailable' => 'Non disponible',
		'nosubject' => '(Aucun sujet)',
	],
	'changepassword' => [
		'old_password' => 'Ancien mot de passe',
		'new_password' => 'Nouveau mot de passe',
		'new_password_confirm' => 'Nouveau mot de passe (confirmation)',
		'new_password_ifnotempty' => 'Nouveau mot de passe (Veuillez laisser vide pour ne pas changer)',
		'also_change_ftp' => 'Changer aussi le mot de passe du compte FTP principal ?',
		'also_change_webalizer' => 'Changer aussi le mot de passe des statistiques Webalizer ?',
	],
	'cronjobs' => [
		'notyetrun' => 'Pas encore lancé',
	],
	'customer' => [
		'documentroot' => 'Chemin',
		'name' => 'Nom',
		'firstname' => 'Prénom',
		'company' => 'Entreprise',
		'street' => 'Rue',
		'zipcode' => 'Code postal',
		'city' => 'Ville',
		'phone' => 'Téléphone',
		'fax' => 'Fax',
		'email' => 'E-mail',
		'customernumber' => 'Numéro du client',
		'diskspace' => 'Espace Web (Mo)',
		'traffic' => 'Trafic (Go)',
		'mysqls' => 'Base(s) de données MySQL',
		'emails' => 'Adresse(s) e-mail',
		'accounts' => 'Accès e-mail',
		'forwarders' => 'Transfert(s) e-mail',
		'ftps' => 'Accès FTP',
		'subdomains' => 'Sous-domaine(s)',
		'domains' => 'Domaine(s)',
		'email_quota' => 'Quota e-mail',
		'email_imap' => 'E-mail IMAP',
		'email_pop3' => 'E-mail POP3',
		'mail_quota' => 'Quota e-mail',
		'title' => 'Titre',
		'country' => 'Pays',
	],
	'dkim' => [
		'dkim_prefix' => [
			'title' => 'Prefix DKIM',
			'description' => 'Veuillez entrer l\'emplacement des fichiers RSA pour DKIM ainsi que l\'emplacement du fichier de configuration pour le plugin Milter',
		],
		'dkim_domains' => [
			'title' => 'Nom du fichier DKIM',
			'description' => '<strong>Nom du fichier</strong> des paramètres DKIM pour les domaines tel que entré dans la configuration de DKIM-milter',
		],
		'dkim_dkimkeys' => [
			'title' => 'Nom du fichier des clefs DKIM',
			'description' => '<strong>Nom du fichier</strong> des paramètres des clefs DKIM tel que entré dans la configuration de DKIM-milter',
		],
		'dkimrestart_command' => [
			'title' => 'Commande de redémarrage de DKIM-milter',
			'description' => 'Veuillez entrer la commande de redémarrage du service DKIM-milter',
		],
		'use_dkim' => [
			'title' => 'Activer le support DKIM ?',
			'description' => 'Voulez-vous utiliser le système DKIM (DomainKeys Identified Mail) ?',
		],
	],
	'dns' => [
		'destinationip' => 'IP du domaine',
		'standardip' => 'IP standard du serveur',
		'a_record' => 'Enregistrement de type "A" (IPv6 optionnel)',
		'cname_record' => 'Enregistrement CNAME',
		'mxrecords' => 'Définition des enregistrements MX',
		'standardmx' => 'Enregistrements MX standard du serveur',
		'mxconfig' => 'Enregistrements MX personnalisé',
		'priority10' => 'Priorité 10',
		'priority20' => 'Priorité 20',
		'txtrecords' => 'Définir des enregistrement TXT',
		'txtexample' => 'Exemple (pour SPF) :<br />v=spf1 ip4:xxx.xxx.xx.0/23 -all',
	],
	'domain' => [
		'openbasedirpath' => 'Dossier "OpenBasedir"',
		'docroot' => 'Identique au dossier ci-dessus',
		'homedir' => 'Dossier Principal',
	],
	'domains' => [
		'description' => 'Ici, vous pouvez ajouter des sites et domaines et changer leurs doosiers.<br />Il vous faudra patienter quelques minutes après chaque changement pour que la configuration soit activée.',
		'domainsettings' => 'Configuration des Domaines',
		'domainname' => 'Nom du Domaine',
		'subdomain_add' => 'Ajouter un sous-domaine',
		'subdomain_edit' => 'Changer un sous-domaine',
		'wildcarddomain' => 'Domaine générique (Wilcard) ?',
		'aliasdomain' => 'Alias pour le domaine',
		'noaliasdomain' => 'Domaine sans alias',
		'hasaliasdomains' => 'Le domaine possède un ou des alias.',
		'statstics' => 'Fréquentation',
		'isassigneddomain' => 'Le domaine est attribué',
		'add_date' => 'Ajouter à froxlor',
		'registration_date' => 'Ajouter à l\'enregistrement',
	],
	'emails' => [
		'description' => 'Ici, vous pouvez ajouter vos boîtes e-mails.<br /><br />Les informations pour configurer votre logiciel e-mail sont les suivantes : <br /><br />Nom du serveur : <b><i>votre-domaine.com</i></b><br />Identifiant : <b><i>l\'adresse e-mail</i></b><br />Mot de passe : <b><i>le mot de passe que vous avez choisi</i></b>',
		'emailaddress' => 'Adresse',
		'emails_add' => 'Ajouter une adresse e-mail',
		'emails_edit' => 'Changer une adresse e-mail',
		'catchall' => 'Catchall',
		'iscatchall' => 'Définir comme adresse "catchall" ?',
		'account' => 'Accès',
		'account_add' => 'Ajouter un accès',
		'account_delete' => 'Supprimer l\'accès',
		'from' => 'de',
		'to' => 'à',
		'forwarders' => 'Réexpédition',
		'forwarder_add' => 'Ajouter un renvoi',
		'alternative_emailaddress' => 'Adresse e-mail alternative',
		'quota' => 'Quota',
		'noquota' => 'Pas de quota',
		'updatequota' => 'Mise à jour',
	],
	'error' => [
		'error' => 'Erreur',
		'directorymustexist' => 'Le dossier que vous avez choisi n\'existe pas. Veuillez ajouter le dossier avec votre client FTP.',
		'filemustexist' => 'Le fichier que vous avez sélectionné n\'existe pas.',
		'allresourcesused' => 'Vous avez déjà utilisé toutes les ressources.',
		'domains_cantdeletemaindomain' => 'Vous ne pouvez pas supprimer un domaine qui est utilisé pour des adresses e-mails.',
		'domains_canteditdomain' => 'Vous n\'avez pas le droit de configurer ce domaine.',
		'domains_cantdeletedomainwithemail' => 'Vous ne pouvez pas supprimer un domaine qui est utilisé pour des e-mails. Vous devez d\'abord supprimer toutes les adresses e-mails qu\'il contient.',
		'firstdeleteallsubdomains' => 'Il faut d\'abord supprimer tous les sous-domaines avant d\'ajouter un domaine "wildcard".',
		'youhavealreadyacatchallforthisdomain' => 'Vous avez déjà défini une adresse "catchall" pour ce domaine.',
		'ftp_cantdeletemainaccount' => 'Vous ne pouvez pas supprimer votre accès principal.',
		'login' => 'Identifiant / mot de passe invalide.',
		'login_blocked' => 'Cet identifiant a été bloqué à cause de nombreuses tentatives de connexions invalides.<br />Veuillez réessayer dans %s secondes.',
		'notallreqfieldsorerrors' => 'Vous n\'avez pas rempli toutes les cases obligatoires ou vous les avez remplis avec des informations invalides.',
		'oldpasswordnotcorrect' => 'L\'ancien mot de passe n\'est pas correct.',
		'youcantallocatemorethanyouhave' => 'Vous ne pouvez pas distribuer plus de ressources qu\'il n\'en reste.',
		'mustbeurl' => 'Vous n\'avez pas entré une adresse URL valide.',
		'invalidpath' => 'Vous n\'avez pas choisi une adresse URL valide (probablement à cause de problèmes avec le listing de dossiers ?)',
		'stringisempty' => 'Entrée manquante',
		'stringiswrong' => 'Entrée invalide',
		'newpasswordconfirmerror' => 'Le nouveau mot de passe et sa confirmation ne sont pas identiques pas.',
		'mydomain' => '"domaine"',
		'loginnameexists' => 'L\'identifiant "%s" existe déjà.',
		'emailiswrong' => 'L\'adresse "%s" contient des signes invalides ou est incomplète.',
		'loginnameiswrong' => 'L\'identifiant "%s" contient des signes invalides.',
		'userpathcombinationdupe' => 'Cette combinaison d\'identifiant et de dossier existe déjà.',
		'patherror' => 'Erreur générale ! Le dossier ne doit pas être vide.',
		'errordocpathdupe' => 'Il y a déjà une option concernant le dossier "%s".',
		'adduserfirst' => 'Vous devez d\'abord ajouter un.',
		'domainalreadyexists' => 'Le domaine "%s" existe déjà.',
		'nolanguageselect' => 'Aucune langue choisis.',
		'nosubjectcreate' => 'Il faut entrer un sujet.',
		'nomailbodycreate' => 'Il faut entrer un corps de texte.',
		'templatenotfound' => 'Aucun modèle trouvé.',
		'alltemplatesdefined' => 'Vous avez déjà appliqué des modèles pour toutes les langues.',
		'wwwnotallowed' => 'Un sous-domaine ne peut pas s\'appeler www.',
		'subdomainiswrong' => 'Le sous-domaine "%s" contient des signes invalides.',
		'domaincantbeempty' => 'Le nom de domaine ne doit pas être vide.',
		'domainexistalready' => 'Le domaine "%s" existe déjà.',
		'domainisaliasorothercustomer' => 'L\'alias du domaine choisi est soit un alias existant d\'un autre client ou soit fait référence à lui même.',
		'emailexistalready' => 'L\'adresse "%s" existe déjà.',
		'maindomainnonexist' => 'Le domaine "%s" n\'existe pas.',
		'destinationnonexist' => 'Veuillez écrire votre adresse de renvoi à l\'emplacement "à".',
		'destinationalreadyexistasmail' => 'Le renvoi vers l\'adresse "%s" existe déjà comme adresse active.',
		'destinationalreadyexist' => 'Il existe déjà une réexpédition vers l\'adresse "%s".',
		'destinationiswrong' => 'L\'adresse "%s" contient des signes invalides ou est incomplète.',
		'loginnameissystemaccount' => 'Vous ne pouvez pas créer de compte ressemblant aux comptes système (ex : "%s"). Veuillez entrer un autre nom de compte.',
		'ipstillhasdomains' => 'La combinaison IP / port est encore utilisée, veuillez réassigner le ou les domaines existant(s) avec cette adresse IP / port concerné(s) à une autre combinaison IP / port avant de supprimer celle-ci.',
		'cantdeletedefaultip' => 'Vous ne pouvez pas supprimer cette combinaison IP / Port, veuillez d\'abord attribuer une autre combinaison IP / Port par défaut à ce revendeur avant de supprimer celle-ci.',
		'cantdeletesystemip' => 'Vous ne pouvez pas créer, modifier ou supprimer l\'IP du système.',
		'myipdefault' => 'Choissez une combinaison IP / port par défaut.',
		'myipnotdouble' => 'Cette combinaison existe déjà',
		'cantchangesystemip' => 'Vous ne pouvez pas modifier l\'adresse IP du système, ni en ajouter de nouvelle.',
		'sessiontimeoutiswrong' => 'Seule une valeur numérique pour le temps d\'inactivité est autorisée.',
		'maxloginattemptsiswrong' => 'Seule une valeur numérique pour "nombre maximum de tentative de connexion" est autorisée.',
		'deactivatetimiswrong' => 'Seule une valeur numérique pour la durée de désactivation est autorisée.',
		'accountprefixiswrong' => 'Le "Préfixe client" n\'est pas valide.',
		'mysqlprefixiswrong' => 'Le "Préfixe SQL" n\'est pas valide.',
		'ftpprefixiswrong' => 'Le "Préfixe FTP" n\'est pas valide.',
		'ipiswrong' => 'L\'"Adresse IP" n\'est pas valide.',
		'vmailuidiswrong' => 'L\'"UID e-mail" est incorrect. Seul un UID numérique est autorisé.',
		'vmailgidiswrong' => 'Le "GID e-mail" est incorrect. Seul un GID numérique est autorisé.',
		'adminmailiswrong' => 'L\'adresse e-mail de l\'administrateur est incorrect. Seulement une adresse e-mail valide est autorisé.',
		'pagingiswrong' => 'La valeur "Nombre de résultats page" est incorrecte. Seul une valeur numérique est autorisée.',
		'phpmyadminiswrong' => 'Le lien pour phpMyAdmin n\'est pas valide.',
		'webmailiswrong' => 'Le lien pour le WebMail n\'est pas valide.',
		'webftpiswrong' => 'Le lien pour le WebFTP n\'est pas valide.',
		'stringformaterror' => 'La valeur pour "%s" n\'est pas dans un format reconnu.',
		'youcantdeleteyourself' => 'Vous ne pouvez pas supprimer votre propre compte pour des raisons évidente de sécurité ...',
		'youcanteditallfieldsofyourself' => 'Note : Vous ne pouvez pas éditer tous les champs de votre propre compte pour des raisons de sécurité.',
		'documentrootexists' => 'Le dossier "%s" existe déjà pour cet utilisateur. Veuillez le supprimer / déplacer avant de réessayer l\'ajout de cet utilisateur.',
		'formtokencompromised' => 'La requète semble compromise. Pour des raisons de sécurité, vous avez été déconnecté.',
		'logerror' => 'Erreur log : %s',
		'nomessagetosend' => 'Vous n\'avez pas entré de message.',
		'norecipientsgiven' => 'Vous n\'avez pas spécifier de destinataire',
		'errorsendingmail' => 'Echec d\'envoi du message à "%s"',
		'cannotreaddir' => 'Impossible de lire dossier "%s"',
		'vmailquotawrong' => 'La taille du quota doit être entre 1 et 999',
		'invalidip' => 'Adresse IP invalide : %s',
		'invalidmysqlhost' => 'Adresse hôte MySQL invalide : "%s"',
		'cannotuseawstatsandwebalizeratonetime' => 'Vous ne pouvez pas activer AWStats <u>et</u> Webalizer en même temps. Veuillez n\'en choisir qu\'un seul.',
		'cannotwritetologfile' => 'Ne peut ouvrir le fichier de log %s en écriture',
	],
	'extras' => [
		'description' => 'Ici, vous pouvez ajouter des extras, comme par exemple, la protection de dossiers du site.<br />Il vous faudra patienter quelques minutes après chaque changement pour que la configuration soit activée.',
		'directoryprotection_add' => 'Ajouter une protection de dossier',
		'view_directory' => 'Aperçu du dossier',
		'pathoptions_add' => 'Ajouter des options sur le dossier',
		'directory_browsing' => 'Afficher le contenu des dossiers',
		'pathoptions_edit' => 'Modifier les options de dossier',
		'errordocument404path' => 'Emplacement du document "Erreur 404"',
		'errordocument403path' => 'Emplacement du document "Erreur 403"',
		'errordocument500path' => 'Emplacement du document "Erreur 500"',
		'errordocument401path' => 'Emplacement du document "Erreur 401"',
	],
	'ftp' => [
		'description' => 'Ici, vous pouvez ajouter des accès FTP supplémentaires.<br />Les changements, ainsi que l\'accès, sont immédiatement opérationnels.',
		'account_add' => 'Ajouter un accès',
	],
	'index' => [
		'customerdetails' => 'Informations personnelles',
		'accountdetails' => 'Informations du compte',
	],
	'logger' => [
		'date' => 'Date',
		'type' => 'Type',
		'action' => 'Action',
		'user' => 'Utilisateur',
		'truncate' => 'Vider les logs',
	],
	'login' => [
		'username' => 'Identifiant',
		'password' => 'Mot de passe',
		'language' => 'Langue',
		'login' => 'Se connecter',
		'logout' => 'Se déconnecter',
		'profile_lng' => 'Langue du profil',
		'forgotpwd' => 'Mot de passe oublié ?',
		'presend' => 'Réinitialiser le mot de passe',
		'email' => 'Adresse e-mail',
		'remind' => 'Réinitialiser mon mot de passe',
		'usernotfound' => 'Erreur : utilisateur inconnu !',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Bonjour,\\n\\nvotre accès POP3 / IMAP {EMAIL}\\na été créé avec succès.\\n\\nCeci est un e-mail généré automatiquement, veuillez ne pas répondre à ce message.\\n\\nCordialement,\\nL\'équipe froxlor\\nhttp://www.froxlor.org',
			'subject' => 'Accès POP3 / IMAP créé',
		],
		'createcustomer' => [
			'mailbody' => 'Bonjour {FIRSTNAME} {NAME},\\n\\nVous trouverez ci-dessous vos informations d\'accès au panel d\'administration :\\n\\nAdresse d\'administration : http://demo.froxlor.org\\n\\nIdentifiant : {USERNAME}\\nMot de passe : {PASSWORD}\\n\\nCordialement,\\nL\'équipe froxlor\\nhttp://www.froxlor.org\\n',
			'subject' => 'froxlor : Informations pour votre accès au panel d\'administration',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Bonjour,\\n\\nVotre compte e-mail {EMAIL} a été correctement créé.\\n\\nVotre mot de passe est : {PASSWORD}.\\n\\nCeci est un message généré automatiquemenent, veuillez ne pas répondre à cet e-mail car il ne serait être consulter.\\n\\nCordialement,\\nL\'équipe froxlor.',
			'subject' => 'Compte e-mail correctement créé',
		],
		'password_reset' => [
			'subject' => 'réinitialisation du mot de passe',
			'mailbody' => 'Bonjour {USERNAME},\\n\\nVotre mot de passe pour froxlor a été réinitialiser !\\nLe nouveau mot de passe est : {LINK}\\n\\nCordialement,\\nL\'équipe froxlor.',
		],
	],
	'menu' => [
		'message' => 'Messages',
	],
	'menue' => [
		'main' => [
			'main' => 'Général',
			'changepassword' => 'Changer de mot de passe',
			'changelanguage' => 'Changer de langue',
			'username' => 'Utilisateur : ',
		],
		'email' => [
			'email' => 'E-mail',
			'emails' => 'Adresse(s) e-mail(s)',
			'webmail' => 'Webmail',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Bases de données',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domaines',
			'settings' => 'Paramétres des sites',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Comptes d\'accès FTP',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extras',
			'directoryprotection' => 'Protection des dossiers',
			'pathoptions' => 'Options des dossiers',
		],
		'traffic' => [
			'traffic' => 'Trafic',
			'current' => 'Mois actuel',
		],
		'logger' => [
			'logger' => 'Log système',
		],
	],
	'message' => [
		'norecipients' => 'Aucun e-mail n\'a été envoyé car il n\'existe aucun destinataire dans la base de données',
		'success' => 'Le message a été envoyé aux destinataires "%s"',
	],
	'mysql' => [
		'databasename' => 'Nom de la base de données',
		'databasedescription' => 'Description de la base de données',
		'database_create' => 'Ajouter une base de données',
		'description' => 'Ici, vous pouvez ajouter et effacer des bases de données MySQL.<br />Les changements, ainsi que les bases de données, sont immédiatement opérationnels.<br />Dans le menu, vous trouverez un lien vers phpMyAdmin, avec lequel vous pouvez gérer vos bases de données.<br /><br />L\'accès aux bases de données depuis les scripts PHP fonctionne comme suit : (Il faut remplacer les valeurs en <i><b>italique</b></i> par vos informations !)<br /><br />$connexion = mysql_connect(\'localhost\', \'<i><b>Votre identifiant</b></i>\', \'<i><b>Votre mot de passe</b></i>\');<br />mysql_select_db(\'<i><b>Le nom de la base de données</b></i>\', $connexion);',
	],
	'panel' => [
		'edit' => 'Modifier',
		'delete' => 'Supprimer',
		'create' => 'Ajouter',
		'save' => 'Sauvegarder',
		'yes' => 'Oui',
		'no' => 'Non',
		'emptyfornochanges' => 'Laissez vide pour ne pas modifier',
		'emptyfordefault' => 'Laissez vide pour l\'option standard',
		'path' => 'Dossier',
		'toggle' => 'Activer / Désactiver',
		'next' => 'continuer',
		'dirsmissing' => 'Dossiers non disponibles ou illisibles',
		'urloverridespath' => 'URL (supplante la valeur dossier)',
		'pathorurl' => 'Dossier ou URL',
		'ascending' => 'ascendant',
		'descending' => 'descendant',
		'search' => 'Rechercher',
		'used' => 'utilisé',
		'translator' => 'Traducteur(s)',
		'reset' => 'Ignorer les changements',
		'pathDescription' => 'Si le dossier n\'existe pas, il sera créé automatiquement.',
		'back' => 'Retour',
		'reseller' => 'revendeur',
		'admin' => 'administrateur',
		'customer' => 'client(s)',
		'send' => 'envoyé',
		'nosslipsavailable' => 'Il n\'y a actuellement aucune combinaison IP / Port configurer pour SSL',
		'backtooverview' => 'Retour à l\'aperçu',
		'dateformat' => 'YYYY-MM-DD',
		'dateformat_function' => 'Y-m-d',
		'timeformat_function' => 'H:i:s',
		'default' => 'Par défaut',
		'never' => 'Jamais',
		'active' => 'Actif',
		'please_choose' => 'Veuillez choisir',
	],
	'pwdreminder' => [
		'success' => 'Mot de passe correctement réinitialiser.<br />Vous devriez recevoir un e-mail avec votre nouveau mot de passe d\'ici quelques minutes.',
		'notallowed' => 'La réinitialisation des mots de passe est désactivée.',
	],
	'question' => [
		'question' => 'Question de sécurité',
		'admin_customer_reallydelete' => 'Etes-vous sûr de vouloir supprimer le compte "%s" ?<br />ATTENTION ! Toutes ses informations seront supprimées ! Une fois fait, il vous appartiendra de supprimer manuellement tous les dossiers du compte sur le système de fichiers.',
		'admin_domain_reallydelete' => 'Etes-vous sûr de vouloir supprimer le domaine "%s" ?',
		'admin_domain_reallydisablesecuritysetting' => 'Etes-vous sûr de vouloir désactiver les modes de sécurité suivants : OpenBasedir et / oû SafeMode ?',
		'admin_admin_reallydelete' => 'Etes-vous sûr de vouloir supprimer l\'administrateur "%s" ?<br />Tous ses comptes seront affectés à l\'administrateur principal.',
		'admin_template_reallydelete' => 'Etes-vous sûr de vouloir supprimer le modèle "%s" ?',
		'domains_reallydelete' => 'Etes-vous sûr de vouloir supprimer le domaine "%s" ?',
		'email_reallydelete' => 'Etes-vous sûr de vouloir supprimer l\'adresse e-mail "%s" ? ',
		'email_reallydelete_account' => 'Etes-vous sûr de vouloir supprimer l\'accès e-mail "%s" ?',
		'email_reallydelete_forwarder' => 'Etes-vous sûr de vouloir supprimer le renvoi vers "%s" ?',
		'extras_reallydelete' => 'Etes-vous sûr de vouloir supprimer la protection du dossier "%s" ?',
		'extras_reallydelete_pathoptions' => 'Etes-vous sûr de vouloir supprimer les options du dossier "%s" ?',
		'ftp_reallydelete' => 'Etes-vous sûr de vouloir supprimer l\'accès ftp "%s" ?',
		'mysql_reallydelete' => 'Etes-vous sûr de vouloir supprimer la base de données "%s" ?<br />ATTENTION : Toutes les données seront perdues à jamais !',
		'admin_configs_reallyrebuild' => 'Etes-vous sûr de vouloir régénérer les fichiers de configuration Apache et Bind ?',
		'admin_ip_reallydelete' => 'Etes-vous sûr de vouloir supprimer l\'adresse IP "%s" ?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Etes-vous sûr de vouloir différencier la racine principale de ce domaine de la racine principale du client ?',
		'admin_counters_reallyupdate' => 'Etes-vous sûr de vouloir recalculer les ressources utilisées ?',
		'admin_cleartextmailpws_reallywipe' => 'Etes-vous sûr de vouloir retirer tous les mots de passe en clairs des comptes e-mails de la table mail_users ? Cette action ne peut être annulée !',
		'logger_reallytruncate' => 'Etes-vous sûr de vouloir vider la table "%s" ?',
		'admin_quotas_reallywipe' => 'Etes-vous sûr de vouloir retirer tous les quotas de la table mail_users ? Cette action ne peut être annulée !',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Durée d\'inactivité maximale',
			'description' => 'Combien de secondes d\'inactivité avant qu\'une session ne se ferme ?',
		],
		'accountprefix' => [
			'title' => 'Préfix des comptes',
			'description' => 'Quel préfix doivent avoir les comptes ?',
		],
		'mysqlprefix' => [
			'title' => 'Préfix SQL',
			'description' => 'Quel préfix doivent avoir les bases de données ?',
		],
		'ftpprefix' => [
			'title' => 'Préfix FTP',
			'description' => 'Quel préfix doivent avoir les accès FTP ?',
		],
		'documentroot_prefix' => [
			'title' => 'Dossier de stockage',
			'description' => 'Oû doivent être stockés tous les dossiers et fichiers des différents comptes ?',
		],
		'logfiles_directory' => [
			'title' => 'Dossier des fichiers de log',
			'description' => 'Oû doivent être stockés les archives des logs d\'accès du serveur Web ?',
		],
		'ipaddress' => [
			'title' => 'Adresse IP',
			'description' => 'Quelle est l\'adresse IP du serveur ?',
		],
		'hostname' => [
			'title' => 'Nom d\'hôte',
			'description' => 'Quel est le nom d\'hôte (hostname) du serveur ?',
		],
		'apachereload_command' => [
			'title' => 'Commande de rechargement d\'Apache',
			'description' => 'Quelle est la commande pour recharger / redémarrer Apache ?',
		],
		'bindconf_directory' => [
			'title' => 'Emplacement du dossier de configuration de Bind / Named',
			'description' => 'Oû doit être stocké la configuration de Bind / Named ?',
		],
		'bindreload_command' => [
			'title' => 'Commande de rechargement de Bind / Named',
			'description' => 'Quelle est la commande pour recharger / redémarrer Bind / Named ?',
		],
		'vmail_uid' => [
			'title' => 'UID des e-mails',
			'description' => 'Quel UID doivent avoir les e-mails ?',
		],
		'vmail_gid' => [
			'title' => 'GID des e-mails',
			'description' => 'Quel GID doivent avoir les e-mails ?',
		],
		'vmail_homedir' => [
			'title' => 'Emplacement des e-mails',
			'description' => 'Dans quel dossier doivent être stocker les e-mails ?',
		],
		'adminmail' => [
			'title' => 'Adresse e-mail de l\'administrateur',
			'description' => 'Quelle est l\'adresse e-mail par défaut des e-mails envoyés par froxlor ?',
		],
		'phpmyadmin_url' => [
			'title' => 'Adresse URL de phpMyAdmin',
			'description' => 'A quelle adresse se trouve phpMyAdmin ?',
		],
		'webmail_url' => [
			'title' => 'Adresse URL du WebMail',
			'description' => 'A quelle adresse se trouve le WebMail ?',
		],
		'webftp_url' => [
			'title' => 'Adresse URL du WebFTP',
			'description' => 'A quelle adresse se trouve le WebFTP ?',
		],
		'language' => [
			'description' => 'Quelle langue est la langue par défaut ?',
		],
		'maxloginattempts' => [
			'title' => 'Nombre d\'essais maximum avant désactivation',
			'description' => 'Nombre de tentatives maximum avant la désactivation de l\'accès.',
		],
		'deactivatetime' => [
			'title' => 'Durée de la désactivation',
			'description' => 'Durée (en secondes) pendant laquelle l\'accès sera désactivé.',
		],
		'pathedit' => [
			'title' => 'Mode de sélection des dossiers',
			'description' => 'Choisir un dossier par une liste déroulante ou l\'entrer manuellement ?',
		],
		'nameservers' => [
			'title' => 'Serveurs de nom «Nameservers»',
			'description' => 'Une liste séparée par des virgules contenant les noms d\'hôtes de tous les serveurs de noms. Le premier dans la liste sera le serveur primaire.',
		],
		'mxservers' => [
			'title' => 'Serveurs de messagerie «MX»',
			'description' => 'Une liste séparée par des virgules contenant les serveurs de messagerie avec leur poid : un nombre et le nom d\'hôte séparé par un espace; par exemple : "10 mx.exemple.com".',
		],
		'paging' => [
			'title' => 'Nombre de résultats par page',
			'description' => 'Nombre de résultats par page ? (0 = Désactive la pagination)',
		],
		'defaultip' => [
			'title' => 'IP / Port par défaut',
			'description' => 'Quel est l\'IP / Port par défaut ?',
		],
		'phpappendopenbasedir' => [
			'title' => 'Dossier(s) de l\'OpenBasedir',
			'description' => 'Liste de dossiers séparée par des virgules qui sera ajouté à la variable "OpenBasedir" des conteneurs vHosts.',
		],
		'natsorting' => [
			'title' => 'Utiliser un tri naturel dans les différentes vues',
			'description' => 'Trier les listes comme web1 -> web2 -> etc ... -> web11 au lieu de web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Dossier "DocumentRoot" pour les utilisateurs désactivés',
			'description' => 'Quand un utilisateur est désactivé, ce dossier sera utilisé comme dossier racine pour le serveur Web. Laissez vide pour ne pas créer de vHost et ne rien afficher du tout lorsque l\'utilisateur est désactivé.',
		],
		'mailpwcleartext' => [
			'title' => 'Sauvegarder aussi les mots de passe des comptes e-mails de façon décrypter dans la base de données',
			'description' => 'Si cela est à Oui, tous les mots de passe seront aussi sauvegarder de façon décrypter dans la table mail_users (en texte clair pour toutes personnes qui auraient accès à la base de données). Activer cette option, uniquement si vous en avez vraiment besoin !',
			'removelink' => 'Cliquez ici pour retirer tous les mots de passe en texte clair de la base de données.',
		],
		'ftpdomain' => [
			'title' => 'Comptes FTP @domaine',
			'description' => 'Les utilisateurs peuvent-ils créer des comptes FTP de la forme utilisateur@domaine.com ?',
		],
		'mod_fcgid' => [
			'title' => 'Utiliser PHP par mod_fcgid / suexec',
			'description' => 'Utiliser mod_fcgid / suexec / libnss_mysql pour lancer PHP avec le compte correspondant à l\'utilisateur ?<br/><b>Cela à besoin d\'une configuration spécifique d\'Apache !</b>',
			'configdir' => [
				'title' => 'Dossier de configuration FCGI',
				'description' => 'Oû doivent être stockés les fichiers de configuration pour FCGI ?',
			],
			'tmpdir' => [
				'title' => 'Dossier temporaire pour FCGI',
			],
		],
		'sendalternativemail' => [
			'title' => 'Utiliser une adresse e-mail alternative',
			'description' => 'Envoyer le mot de passe du compte e-mail à une adresse différents pour la création du compte e-mail ?',
		],
		'apacheconf_vhost' => [
			'title' => 'Dossier / fichier de configuration des vHosts pour Apache',
			'description' => 'Oû doit être stocké le fichier de configuration des vHosts ? Vous pouvez soit entrer le nom d\'un fichier (tous les vHosts dans un seul fichier), soit le nom d\'un dossier (chacun des vHosts dans un fichier séparé du dossier).',
		],
		'apacheconf_diroptions' => [
			'title' => 'Fichier / dossier de configuration des options des dossiers pour Apache',
			'description' => 'Oû doit être stocké le fichier de configuration des options de dossiers ? Vous pouvez soit entrer le nom d\'un fichier (toutes les options des dossiers dans un seul fichier), soit le nom d\'un dossier (chacune des options de dossier dans un fichier séparé du dossier).',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Dossier du fichier htpasswd pour Apache',
			'description' => 'Oû doit être stocké le fichier de configuration de protection des dossiers "htpasswd" pour Apache ?',
		],
		'mysql_access_host' => [
			'title' => 'Hôtes de connexion MySQL',
			'description' => 'Une liste séparée par des virgules contenant la liste des hôtes depuis lesquels les utilisateurs sont autorisés à se connecter au serveur MySQL.',
		],
		'webalizer_quiet' => [
			'title' => 'Sortie Webalizer',
			'description' => 'Verbosité du programme Webalizer',
		],
		'logger' => [
			'enable' => 'Activer / Désactiver les logs',
			'severity' => 'Niveau de log',
			'types' => [
				'title' => 'Type(s) de log',
				'description' => 'Spécifiez les types de log séparés par des virgules.<br />Les types de log disponible sont : syslog, file, mysql',
			],
			'logfile' => 'Nom du fichier de log, dossier + nom du fichier',
			'logcron' => 'Loguer les travaux de cron',
			'logcronoption' => [
				'never' => 'Jamais',
				'once' => 'Une fois',
				'always' => 'Toujours',
			],
		],
		'ssl' => [
			'openssl_cnf' => 'Paramètres par défaut pour créer le certificat',
		],
		'default_vhostconf' => [
			'title' => 'Paramètres par défaut pour les vHosts',
		],
		'mail_quota' => [
			'title' => 'Quota de la boîte aux lettres',
			'description' => 'Quota par défaut pour toutes nouvelles boîtes aux lettres créées.',
		],
		'mail_quota_enabled' => [
			'title' => 'Utiliser les quotas de boîtes aux lettres pour les clients',
			'description' => 'Activez cette option pour utiliser les quotas sur les boîtes aux lettres. Par défaut, cette option est à <b>Non</b> car cela requiert une configuration spécifique.',
			'removelink' => 'Cliquez ici pour retirer tous les quotas de tous les comptes e-mails.',
		],
		'decimal_places' => 'Nombre de décimales à afficher pour le trafic / espace web',
		'webalizer_enabled' => 'Activer les statistiques Webalizer',
		'awstats_enabled' => 'Activer les statistiques AWStats',
		'selfdns' => [
			'title' => 'Paramètres manuel des DNS du domaine',
		],
		'selfdnscustomer' => [
			'title' => 'Permettre aux clients de modifier les paramètes DNS du domaine',
		],
		'unix_names' => [
			'title' => 'Utiliser des noms d\'utilisateurs compatible UNIX',
			'description' => 'Vous permet d\'utiliser les <strong>-</strong> et <strong>_</strong> dans les noms d\'utilisateurs si l\'option est à <strong>Non</strong>',
		],
		'allow_password_reset' => [
			'title' => 'Permettre aux clients de réinitialiser leurs mots de passe',
			'description' => 'Les clients peuvent réinitialiser leurs mots de passe et il sera envoyé à leurs propres adresses e-mails',
		],
		'allow_password_reset_admin' => [
			'title' => 'Permettre la réinitialisation des mots de passe par les administrateurs',
			'description' => 'Les administrateurs / revendeurs peuvent réinitialiser leurs mots de passe et il sera envoyé à leurs propres adresses e-mails',
		],
	],
	'traffic' => [
		'month' => 'Mois',
		'day' => 'Jour',
		'months' => [
			1 => 'Janvier',
			2 => 'Février',
			3 => 'Mars',
			4 => 'Avril',
			5 => 'Mai',
			6 => 'Juin',
			7 => 'Juillet',
			8 => 'Août',
			9 => 'Septembre',
			10 => 'Octobre',
			11 => 'Novembre',
			12 => 'Décembre',
		],
		'mb' => 'Trafic (Mo)',
		'distribution' => '<font color="#019522">FTP</font> | <font color="#0000FF">HTTP</font> | <font color="#800000">E-mail</font>',
		'sumhttp' => 'Trafic HTTP total entrant',
		'sumftp' => 'Trafic FTP total entrant',
		'summail' => 'Trafic E-mail total entrant',
	],
	'translator' => 'Tim Zielosko, Aldo Reset, Romain MARIADASSOU',
];
